 /**
 *
 * \file        HPRFGW_RFSlaveIntf.c
 *
 * \brief       This file contains the RF slave interface API functions.
 *
 * \detail
 *
 * \author      Hazrat Shah
 *
 * \date        11/28/2006
 * \warning
 * \note
 * \review
 */

#include "hprfgw_config.h"
// MNT - 3/21/2007 - Dependency Removal tag begin
//#include "console.h"
//#include "hprfgw_eeprom.h"
// MNT - 3/21/2007 - Dependency Removal tag end
#if defined (OS_NUCLEUS)
 #include "cpu.h"
 #include "system.h"
#endif
#include "hprfgw_rfResultCode.h"
#include "hprfgw_rfHeartbeat.h"
#include "hprfgw_rfDesc.h"
#include "hprfgw_rfApp.h"
#include "hprfgw_rfTrans.h"
#include "hprfgw_rfRec.h"
#include "hprfgw_rfRecMsg.h"
#include "hprfgw_rfComLog.h"
#include "hprfgw_rfSlaveIntToHost.h"
#include "hprfgw_rfSlaveIntToRfApp.h"
#if defined (OS_NUCLEUS)
 #include "timer.h"
 #include "tp.h"
 #include "rf_serv.h"
 #include "crc.h"
#endif
#if defined(OS_NUCLEUS) || defined(OS_WINCE)
 #include <stdio.h>
 #include <stdlib.h>
 #include <stdarg.h>
 #include <string.h>
 #include <ctype.h>
 #include <wtypes.h>
#endif
#if defined (OS_WINCE)
#include "winreg.h"
#endif
#include "hprf_androidIntfc.h"
#include <linux/spi/spi.h>
//#include "NvRamInterface.h"
#include "../../char/m24m01.h"
#include "../../../../external/crestron/ERInterfaceDLL/nvram_dataMap.h"

////////////////////////////////////////////////////////////////////////////////
//	EXTERNAL
////////////////////////////////////////////////////////////////////////////////
extern	INT8   *ConvertUIDtoString (UINT8 *puid, INT8 *pstr, UINT8 addrmode);
extern  unsigned short CalculateBlockCRC16(unsigned long count,unsigned short crc,void* buffer);

////////////////////////////////////////////////////////////////////////////////
//	DEFINITIONS
////////////////////////////////////////////////////////////////////////////////
DM_RESOURCE_HANDLE g_startupEventGroup = 0;


////////////////////////////////////////////////////////////////////////////////
//	LOCAL DATA
////////////////////////////////////////////////////////////////////////////////
INT32	HOSTAPPINTERFACE_GetGatewayUID_PANID_ADDRMODE(BOOL *pUIDValid, UINT8 *pUID, UINT16 *pPanid, UINT8 *pAddrmode, UINT8 *defUID, UINT16 defPanid, UINT8 defAddrMode);
INT32	HOSTAPPINTERFACE_GetLocalDeviceUID_PANID(BOOL *pUIDValid, UINT8 *pUID, UINT16 *pPanid, UINT8 *defUID, UINT16 defPanid);
INT32	HOSTAPPINTERFACE_StoreGatewayUID_PANID(UINT8 *pUID, UINT16 PANID, UINT8 AddrMode);
INT32	HOSTAPPINTERFACE_StoreGatewayName (UINT8 *pName);
INT32	HOSTAPPINTERFACE_StoreLocalDeviceUID_PANID(UINT8 *pUID, UINT16 PANID);
INT32	HOSTAPPINTERFACE_StoreLocalDeviceUID(UINT8 *pUID);
INT32	HOSTAPPINTERFACE_StoreLocalDevicePANID(UINT16 PANID);
INT32	HOSTAPPINTERFACE_ProcessCresnetPacket(UINT8 *pBuf, UINT16 BufLen);
INT32	HOSTAPPINTERFACE_LinkReply(BOOL Linked, BOOL CSStatus);
INT32	HOSTAPPINTERFACE_RFCommunicationError(BOOL SeqErr, BOOL SegErr);
INT32	HOSTAPPINTERFACE_BufferOverFlows (BOOL TxBuf, BOOL RxBuf);
INT32	HOSTAPPINTERFACE_EchoReply(UINT8 *pBuf, UINT8 BufLen);
INT32	HOSTAPPINTERFACE_ProcessLocalCresnetPacket(UINT8 *pBuf, UINT16 BufLen);
INT32	HOSTAPPINTERFACE_GetRetryCount(UINT8 *count, UINT8 defCount);
INT32	HOSTAPPINTERFACE_StoreRetryCount(UINT8 count);
INT32	HOSTAPPINTERFACE_GetRetryDelay(UINT8 *RetryDly, UINT8 Cnt, UINT8 *defRetryDly);
INT32	HOSTAPPINTERFACE_StoreRetryDelay(UINT8 RetryDly, UINT8 Cnt);
INT32	HOSTAPPINTERFACE_GetPowerLevel(UINT16 *powerLevel, UINT16 defPowerLevel);
INT32	HOSTAPPINTERFACE_StorePowerLevel(UINT16 powerLevel);
INT32	HOSTAPPINTERFACE_GetChannel	(UINT8 *Channel, UINT8 defChannel);
INT32	HOSTAPPINTERFACE_StoreChannel (UINT8 Channel);
INT32	HOSTAPPINTERFACE_GetCCAEnergyDetectThr(UINT8 *ccaThres, UINT8 defCcaThres);
INT32	HOSTAPPINTERFACE_StoreCCAEnergyDetectThr(UINT8 ccaThres);
INT32	HOSTAPPINTERFACE_GetRSSIPowerCompOffset(UINT8 *rssiOffset, UINT8 defRssiOffset);
INT32	HOSTAPPINTERFACE_StoreRSSIPowerCompOffset(UINT8 rssiOffset);
INT32	HOSTAPPINTERFACE_GetResultCodeTimeout(UINT16 *timeout, UINT16 defTimeout);
INT32	HOSTAPPINTERFACE_StoreResultCodeTimeout(UINT16 timeout);
INT32	HOSTAPPINTERFACE_GetHeartBeatRate(UINT8 *heartBeatRate, UINT8 defHeartBeatRate);
INT32	HOSTAPPINTERFACE_StoreHeartBeatRate(UINT8 heartBeatRate);
INT32	HOSTAPPINTERFACE_GetRFID(UINT8 *rfID);
INT32	HOSTAPPINTERFACE_GetTSID(UINT32 *tsID);
INT32	HOSTAPPINTERFACE_GetIDString(INT8 *pBuf, UINT8 * count);
INT32	HOSTAPPINTERFACE_AcquireUpdate(TYPE_GATEWAY_IN_ACQUIRE_LIST* pAcquireResult, UINT8 NoofAcquireEntries, BOOL Finished);
INT32	HOSTAPPINTERFACE_ControlSystemConnectionStatusChange(BOOL CSStatus, BOOL SendUpdateReq);
INT32	HOSTAPPINTERFACE_GatewayConnectionStatusChange(BOOL CSStatus);
INT32	HOSTAPPINTERFACE_GetDeviceOptions (UINT8 *devOpts);
INT32	HOSTAPPINTERFACE_TransmitPipeOverFlowOccured (UINT32 index);
INT32	HOSTAPPINTERFACE_IsRFTxDebugTraceEnabled (BOOL *isEnabled);
INT32	HOSTAPPINTERFACE_IsRFRxDebugTraceEnabled (BOOL *isEnabled);
INT32   HOSTAPPINTERFACE_RFReceiverIndicatorFlash(void);
INT32   HOSTAPPINTERFACE_RFTransmitIndicatorFlash(void);
INT32	HOSTAPPINTERFACE_DeviceLinkLost (UINT8 rfid);
INT32	HOSTAPPINTERFACE_DeviceLinkFound (UINT8 rfid);
INT32	HOSTAPPINTERFACE_CalculateBlockCRC16 (UINT16 len, UINT16 *crc, INT8 *pbuf);
INT32	HOSTAPPINTERFACE_GetDeviceDataField (UINT8 fieldno, INT8 *pbuf, UINT16 *plen);
INT32	HOSTAPPINTERFACE_IsUIDValid (BOOL *pValid);
INT32	HOSTAPPINTERFACE_GetRetryCountOnConnectionReq(UINT8 *count, UINT8 defCount);
INT32	HOSTAPPINTERFACE_StoreRetryCountOnConnectionReq(UINT8 count);
INT32	HOSTAPPINTERFACE_GetPreLinkQueryPacketCnt(UINT8 *count, UINT8 defCount);	
INT32	HOSTAPPINTERFACE_StorePreLinkQueryPacketCnt(UINT8 count);	
INT32	HOSTAPPINTERFACE_InitRoamingDescriptiveTable(void);
INT32	HOSTAPPINTERFACE_SetRoamingGatewayUID_PANID(UINT8 *gwuid,UINT16 panid);

INT32 StartupWait(enum HPRF_STARTUP_EVENT signal_event);
INT32 RFErrorPrintf(const char* format,...);
INT32 RFConsolePrintf(const char* format,...);
INT32 ErrorHandler(char *msg);
INT32 IntfcHwDelayMsec(UINT32 ms);
INT32 IntfcHwDelayUsec(UINT32 us);
INT32 GetTime(long *time);
INT32 GetDate(short *month,short *day,short *year);
INT32 SystemError(int error);
INT32 GetAddressMode(UINT8 *addrMode, UINT8 defAddrMode);
INT32 StoreAddressMode(UINT8 addrMode);
INT32 GetShortAddress(UINT16 *shortAddr, UINT16 defShortAddr);
INT32 StoreShortAddress(UINT16 shortAddr);
INT32 AcquireStartIndication(void);
INT32 AcquireStopIndication(void);

INT32 HOSTAPPINTERFACE_GetLocalDeviceRFLinkLQIThr (UINT8 *pLQI, UINT8 defaultLQI);
INT32 HOSTAPPINTERFACE_StoreLocalDeviceRFLinkLQIThr (UINT8 LQI);

const TYPE_INTERFACE_TO_HOST_APP RFIntHostApp = {
	HOSTAPPINTERFACE_GetGatewayUID_PANID_ADDRMODE,	
	HOSTAPPINTERFACE_GetLocalDeviceUID_PANID,
	HOSTAPPINTERFACE_StoreGatewayUID_PANID,
	HOSTAPPINTERFACE_StoreGatewayName,
	HOSTAPPINTERFACE_StoreLocalDeviceUID_PANID,
    HOSTAPPINTERFACE_StoreLocalDeviceUID,
    HOSTAPPINTERFACE_StoreLocalDevicePANID,
	HOSTAPPINTERFACE_ProcessCresnetPacket,
	HOSTAPPINTERFACE_LinkReply,
	HOSTAPPINTERFACE_RFCommunicationError,
	HOSTAPPINTERFACE_BufferOverFlows,
	HOSTAPPINTERFACE_ProcessLocalCresnetPacket,
	HOSTAPPINTERFACE_GetRetryCount,
	HOSTAPPINTERFACE_StoreRetryCount,
	HOSTAPPINTERFACE_GetRetryDelay,
	HOSTAPPINTERFACE_StoreRetryDelay,
	HOSTAPPINTERFACE_GetPowerLevel,
	HOSTAPPINTERFACE_StorePowerLevel,
	HOSTAPPINTERFACE_GetChannel,
	HOSTAPPINTERFACE_StoreChannel,
	HOSTAPPINTERFACE_GetCCAEnergyDetectThr,
	HOSTAPPINTERFACE_StoreCCAEnergyDetectThr,
	HOSTAPPINTERFACE_GetRSSIPowerCompOffset,
	HOSTAPPINTERFACE_StoreRSSIPowerCompOffset,
	HOSTAPPINTERFACE_GetResultCodeTimeout,
	HOSTAPPINTERFACE_StoreResultCodeTimeout,
	HOSTAPPINTERFACE_GetHeartBeatRate,
	HOSTAPPINTERFACE_StoreHeartBeatRate,
	HOSTAPPINTERFACE_GetIDString,
	HOSTAPPINTERFACE_AcquireUpdate,
	HOSTAPPINTERFACE_ControlSystemConnectionStatusChange,
	HOSTAPPINTERFACE_GatewayConnectionStatusChange,
	HOSTAPPINTERFACE_GetRFID,
	HOSTAPPINTERFACE_GetTSID,
	HOSTAPPINTERFACE_GetDeviceOptions,
	HOSTAPPINTERFACE_TransmitPipeOverFlowOccured,
	HOSTAPPINTERFACE_IsRFTxDebugTraceEnabled,
	HOSTAPPINTERFACE_IsRFRxDebugTraceEnabled,
    HOSTAPPINTERFACE_RFReceiverIndicatorFlash,
    HOSTAPPINTERFACE_RFTransmitIndicatorFlash,
	HOSTAPPINTERFACE_DeviceLinkLost,
	HOSTAPPINTERFACE_DeviceLinkFound,
	HOSTAPPINTERFACE_CalculateBlockCRC16,	
	HOSTAPPINTERFACE_GetDeviceDataField,
	StartupWait,
	RFConsolePrintf,
	RFErrorPrintf,
	ErrorHandler,
	IntfcHwDelayMsec,
	IntfcHwDelayUsec,
	GetTime,
	GetDate,
	SystemError,
	GetAddressMode,
	StoreAddressMode,
	GetShortAddress,
	StoreShortAddress,
	AcquireStartIndication,
	AcquireStopIndication,
	HOSTAPPINTERFACE_IsUIDValid,
	HOSTAPPINTERFACE_GetLocalDeviceRFLinkLQIThr, 
	HOSTAPPINTERFACE_StoreLocalDeviceRFLinkLQIThr,
	HOSTAPPINTERFACE_GetRetryCountOnConnectionReq,	
	HOSTAPPINTERFACE_StoreRetryCountOnConnectionReq,
	HOSTAPPINTERFACE_GetPreLinkQueryPacketCnt,
	HOSTAPPINTERFACE_StorePreLinkQueryPacketCnt,
	HOSTAPPINTERFACE_InitRoamingDescriptiveTable,
	HOSTAPPINTERFACE_SetRoamingGatewayUID_PANID
};

////////////////////////////////////////////////////////////////////////////////
//
////////////////////////////////////////////////////////////////////////////////

static struct mc13192* get_driver_data(void)
{
    struct spi_device *spi = to_spi_device(&hprf_spi->dev);
    struct mc13192 *rf = spi_get_drvdata(spi);
    return rf;
}


////////////////////////////////////////////////////////////////////////////////
//	EXTERNAL
////////////////////////////////////////////////////////////////////////////////
//INT8   *ConvertUIDtoString (UINT8 *puid, INT8 *pstr, UINT8 addrmode);

// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// MNT - 3/21/2007 - Make sure that these functions do something. Most of the stuff is
// commented out but it should give the device developer an idea of what needs to be
// returned. All the EEProm Entries are specifically commented out for the user to define
// what that means (store in file system/nvram or whatever else makes sense)
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

INT32	HOSTAPPINTERFACE_GetGatewayUID_PANID_ADDRMODE(BOOL *pUIDValid, UINT8 *pUID, UINT16 *pPanid, UINT8 *pAddrMode, UINT8 *defUID, UINT16 defPanid, UINT8 defaddrMode)
{
    struct mc13192* rf = get_driver_data();
    memcpy(pUID, &rf->rfparam.gatewayUID[0], UID_MAX_SIZE);
    *pPanid = rf->rfparam.gatewayPanID;

	*pAddrMode = defaddrMode;

	*pUIDValid = TRUE;

	return SUCCESS;
}

INT32	HOSTAPPINTERFACE_GetLocalDeviceUID_PANID(BOOL *pUidValid, UINT8 *pUID, UINT16 *pPanid, UINT8 *defUID, UINT16 defPanid)
{
    struct mc13192* rf = get_driver_data();
    if (rf->rfparamlocal.UID_Valid != UID_SIGN)
    {
        //Invalid ? For now just return the defaults
        memcpy(pUID, defUID, UID_MAX_SIZE);
        *pUidValid = 0;
        return 0;       // should be a zero return
    }
    memcpy(pUID, &rf->rfparam.UID[0], UID_MAX_SIZE);
    *pPanid = rf->rfparam.panID;

    *pUidValid = TRUE;

    return SUCCESS;
}

INT32	HOSTAPPINTERFACE_StoreGatewayUID_PANID(UINT8 *pUID, UINT16 panid, UINT8 addrmode)
{
    int bytes;
    struct mc13192* rf = get_driver_data();
    // Now update the local variable
    UINT8 buf[RF_DEVICE_MAX_CRESNET_ID_STRING_LEN];

    bytes = m24m01_write(&panid, sizeof(panid), DS_UL_ER_GATEWAYPANID);
    bytes = m24m01_write(pUID, UID_MAX_SIZE, DS_UC_ER_GATEWAYUID);


    memcpy(rf->rfparam.gatewayUID, pUID, UID_MAX_SIZE);
    rf->rfparam.gatewayPanID = panid;
    // Local param string
    ConvertUIDtoString(pUID, buf, gAddrModeLong_c);
    strcpy(rf->rfparamlocal.gatewayUIDString, buf);
    return SUCCESS;
}

INT32	HOSTAPPINTERFACE_StoreGatewayName (UINT8 *pName)
{
    return SUCCESS;
}

INT32	HOSTAPPINTERFACE_StoreLocalDeviceUID_PANID(UINT8 *pUID, UINT16 PANID)
{
    return SUCCESS;
}


INT32	HOSTAPPINTERFACE_StoreLocalDeviceUID(UINT8 *pUID)
{
    return SUCCESS;
}

INT32	HOSTAPPINTERFACE_StoreLocalDevicePANID(UINT16 PANID)
{
    return SUCCESS;
}


INT32	HOSTAPPINTERFACE_ProcessCresnetPacket(UINT8 *pBuf, UINT16 BufLen)
{
    struct mc13192* rf = get_driver_data();
    if(rf->rfparam.RFTraceFlags & RF_GENERIC_DEBUG_FLAG)
    {
        DmConsolePrintf("Local Cresnet packet Len=%02x, data=%02x%02x%02x%02x\r\n", BufLen, *pBuf, *(pBuf+1), *(pBuf+2), *(pBuf+3));
    }
    SendCresnetPacketToApp((void*)pBuf, BufLen);
    return SUCCESS;
}

INT32	HOSTAPPINTERFACE_LinkReply(BOOL Linked, BOOL CSStatus)
{
    struct mc13192* rf = get_driver_data();
    if(rf->rfparam.RFTraceFlags & RF_GENERIC_DEBUG_FLAG)
	    DmConsolePrintf("Link reply Linked=%d, CSStatus=%d\r\n", Linked, CSStatus);
	return (SUCCESS);
}

INT32	HOSTAPPINTERFACE_RFCommunicationError(BOOL SeqErr, BOOL SegErr)
{
    struct mc13192* rf = get_driver_data();
    if(rf->rfparam.RFTraceFlags & RF_GENERIC_DEBUG_FLAG)
	    DmConsolePrintf("CommError SeqErr=%d, SegErr=%d\r\n", SeqErr, SegErr);
	return (SUCCESS);
}

INT32	HOSTAPPINTERFACE_BufferOverFlows (BOOL TxBuf, BOOL RxBuf)
{
    struct mc13192* rf = get_driver_data();
    char rf_restart_msg[] = {2,2,3,0};
    
    // Send Update request
    rf_restart_msg[0] = rf->rfparam.RFID;
    // PRASAD - to do
    //RFIntRFApp.pF_PostCresnetPacket();
    if(rf->rfparam.RFTraceFlags & RF_GENERIC_DEBUG_FLAG)
        DmConsolePrintf("Bufferoverflow TxBuf=%d, RxBuf=%d\r\n", TxBuf, RxBuf);
	return (SUCCESS);
}

INT32	HOSTAPPINTERFACE_EchoReply(UINT8 *pBuf, UINT8 BufLen)
{
    struct mc13192* rf = get_driver_data();
	//	For debug purpose
    if(rf->rfparam.RFTraceFlags & RF_GENERIC_DEBUG_FLAG)
	    DmConsolePrintf("Echo reply Len=%02x, Data=[%02x%02x%02x%02x%02x]\r\n", BufLen, *pBuf, *pBuf+1, *pBuf+2, *pBuf+3, *pBuf+4);
	return (SUCCESS);
}

INT32	HOSTAPPINTERFACE_ProcessLocalCresnetPacket(UINT8 *pBuf, UINT16 BufLen)
{
    struct mc13192* rf = get_driver_data();
    if(rf->rfparam.RFTraceFlags & RF_GENERIC_DEBUG_FLAG)
    {
	    DmConsolePrintf("Local Cresnet packet Len=%02x, data=%02x%02x%02x%02x\r\n", BufLen, *pBuf, *(pBuf+1), *(pBuf+2), *(pBuf+3));
    }
    SendLocalCresnetPacketToApp((void*)pBuf, BufLen);
    return SUCCESS;
}

INT32	HOSTAPPINTERFACE_GetRetryCount(UINT8 *count, UINT8 defCount)
{
    struct mc13192* rf = get_driver_data();
    // HS use this value in RF_PARAM unsigned char   retry; 7/9/2007 5:07PM
    //*count = defCount;
    *count= rf->rfparam.retry;
	return SUCCESS;
}

INT32	HOSTAPPINTERFACE_StoreRetryCount(UINT8 count)
{
    return SUCCESS;
}

INT32	HOSTAPPINTERFACE_GetRetryDelay(UINT8 *RetryDly, UINT8 Cnt, UINT8 *defRetryDly)
{
    //retrydelay[RF_MAX_NO_OF_RETRIES_DELAYS]; use this HS 7/9/2007 5:09PM
	memcpy(RetryDly, defRetryDly, Cnt);
	return SUCCESS;
}

INT32	HOSTAPPINTERFACE_StoreRetryDelay(UINT8 RetryDly, UINT8 Cnt)
{
    // HS will be done only by console. Fix "rfconfig 7/9/2007 5:10PM
    return SUCCESS;
}

INT32	HOSTAPPINTERFACE_GetPowerLevel(UINT16 *powerLevel, UINT16 defPowerLevel)
{
    struct mc13192* rf = get_driver_data();
    //*powerLevel= (unsigned short) RF_GetPowerLevel();
    // PRASAD - to do. If telec test is running it has to return tele test power
	*powerLevel = rf->rfparam.powerhilo;
	return (SUCCESS);
}
INT32	HOSTAPPINTERFACE_StorePowerLevel(UINT16 powerLevel)
{
    return SUCCESS;
}

INT32	HOSTAPPINTERFACE_GetChannel	(UINT8 *Channel, UINT8 defChannel)
{
    struct mc13192* rf = get_driver_data();
    if((rf->rfparam.channel < RF_FIRST_CHANNEL) || (rf->rfparam.channel > RF_LAST_CHANNEL))
    {
        *Channel = defChannel;
    }
    else
    {
        *Channel = rf->rfparam.channel;
    }

	return SUCCESS;
}

INT32	HOSTAPPINTERFACE_StoreChannel (UINT8 Channel)
{
    struct mc13192* rf = get_driver_data();
    int bytes;
    UINT32 dwChannel = (UINT32)Channel;
    bytes = m24m01_write(&dwChannel, sizeof(UINT32), DS_UL_ER_CHANNEL);

    rf->rfparam.channel = Channel;

    if(rf->rfparam.RFTraceFlags & RF_GENERIC_DEBUG_FLAG)
        DmConsolePrintf("Gateway channel: %d \r\n", Channel);

    return SUCCESS;
}

INT32	HOSTAPPINTERFACE_GetCCAEnergyDetectThr(UINT8 *ccaThres, UINT8 defCcaThres)
{
    struct mc13192* rf = get_driver_data();
    *ccaThres = rf->rfparam.CCAEnergyDetectThr;
    return SUCCESS;
}

INT32	HOSTAPPINTERFACE_StoreCCAEnergyDetectThr(UINT8 ccaThres)
{
    struct mc13192* rf = get_driver_data();
    rf->rfparam.CCAEnergyDetectThr= ccaThres;
	return (SUCCESS);
}

INT32	HOSTAPPINTERFACE_GetRSSIPowerCompOffset(UINT8 *rssiOffset, UINT8 defRssiOffset)
{
    struct mc13192* rf = get_driver_data();
    *rssiOffset = rf->rfparam.RSSIPowerCompOffset;
    return SUCCESS;
}
INT32	HOSTAPPINTERFACE_StoreRSSIPowerCompOffset(UINT8 rssiOffset)
{
    struct mc13192* rf = get_driver_data();
    rf->rfparam.RSSIPowerCompOffset = rssiOffset;
    return (SUCCESS);
}
INT32	HOSTAPPINTERFACE_GetResultCodeTimeout(UINT16 *timeout, UINT16 defTimeout)
{
	*timeout = defTimeout;
    return SUCCESS;
}

INT32	HOSTAPPINTERFACE_StoreResultCodeTimeout(UINT16 timeout)
{
    // Not needed HS 7/9/2007 5:16PM
    return SUCCESS;
}
INT32	HOSTAPPINTERFACE_GetHeartBeatRate(UINT8 *heartBeatRate, UINT8 defHeartBeatRate)
{
	*heartBeatRate = defHeartBeatRate;
	return SUCCESS;
}

INT32	HOSTAPPINTERFACE_StoreHeartBeatRate(UINT8 heartBeatRate)
{
    // Not needed 7/9/2007 5:17PM
    return SUCCESS;
}

INT32	HOSTAPPINTERFACE_GetIDString(INT8 *pBuf, UINT8 * count)
{
    struct mc13192* rf = get_driver_data();
	*count = strlen(rf->bootIdMsg);
	//DmConsolePrintf("%s - bootIdMsg len = %u\n", __FUNCTION__, *count);
	memcpy((void*)pBuf, (void*)rf->bootIdMsg, *count);
	return SUCCESS;

}

INT32	HOSTAPPINTERFACE_AcquireUpdate(TYPE_GATEWAY_IN_ACQUIRE_LIST* pAcquireResult, UINT8 NoofAcquireEntries, BOOL Finished)
{
    INT8 buf[RF_DEVICE_MAX_CRESNET_ID_STRING_LEN], i;
    struct mc13192* rf = get_driver_data();
    if (NoofAcquireEntries) {
        for (i = 0; i < NoofAcquireEntries; i++, pAcquireResult++) {
            DmConsolePrintf("Acquire %d in acquire: name[%s] uid[%s] panid[%04x] channel[%02x]\r\n", i,
                    (INT8*) &pAcquireResult->name,
                    ConvertUIDtoString((UINT8*) &pAcquireResult->uid, buf, gAddrModeLong_c), pAcquireResult->panid,
                    pAcquireResult->channel);
            if (i == 0) {
                HOSTAPPINTERFACE_StoreGatewayUID_PANID((UINT8*) &pAcquireResult->uid, (UINT16) pAcquireResult->panid,
                        (UINT8) pAcquireResult->addrmode);
                HOSTAPPINTERFACE_StoreChannel((UINT8) pAcquireResult->channel);
                //RF_Acquire_Stop(1);
                //RF_Acquire_Report_Status(pAcquireResult->name, buf);

                // Copy acquired gateway name to local variable
                // Note Gateway UID string is stored in StoreGatewayUID_PANID function
                strcpy((char*) rf->rfparamlocal.gatewayName, pAcquireResult->name);

                // Copy GW name to local buffer for the application.
                strcpy(&buf[1], pAcquireResult->name);

                buf[0] = HPRF_CTRL_MSG_ACQUIRE_SUCCESS;
                SendCtrlMsgToApp((void*) buf, sizeof(buf));
                if (g_roamingEnabled) {
                    // PRASAD - to do.
                    //RF_Acquire_Report_Roaming_Entry_Status(pAcquireResult->name, buf);
                    //RF_StoreGatewayNamesToFlash();
                }
                //RF_PrintAcquireStatus(pAcquireResult->name);    // PM 02.29.2008: Print gateway name
            }
        }
    }
    else {
        //RF_Acquire_Stop(2);
        buf[0] = HPRF_CTRL_MSG_ACQUIRE_TIMEOUT;
        SendCtrlMsgToApp((void*) buf, sizeof(buf));
        DmConsolePrintf("Acquire done: no gateway found in acquire mode\r\n");
    }
    RFIntRFApp.pF_AcquireStop(TRUE);
    return SUCCESS;
}

INT32	HOSTAPPINTERFACE_ControlSystemConnectionStatusChange(BOOL CSStatus, BOOL SendUpdateReq)
{
    char buf[4];
    
    if (CSStatus == TRUE)
    {
        buf[0] = HPRF_CTRL_MSG_CTRL_SYS_CONNECTED;
        buf[1] = (char) SendUpdateReq;
    }
    else
    {
        buf[0] = HPRF_CTRL_MSG_CTRL_SYS_DISCONNECTED;
        buf[1] = (char) SendUpdateReq;
    }
    SendCtrlMsgToApp((void*)buf, sizeof (buf));

    //RF_ControlSystemConnectionStatusChange(CSStatus, SendUpdateReq);
    DmConsolePrintf("Control System connect update Status=%d, updreq=%s\r\n", CSStatus, SendUpdateReq?"TRUE":"FALSE");
    return SUCCESS;
}

INT32	HOSTAPPINTERFACE_GatewayConnectionStatusChange(BOOL Status)
{
    char buf[GATEWAY_NAME_MAX_SIZE + 8];
    INT8 idstring[RF_DEVICE_MAX_CRESNET_ID_STRING_LEN+1];
    struct mc13192* rf = get_driver_data();

    if (Status)
    {
        // Update gateway name
        strncpy((char *)idstring,(char *)g_pRFDeviceDescriptiveTable[DEVICE_DESCRIPTIVE_TABLE_INDEX].IDInfo.idstring, RF_DEVICE_MAX_CRESNET_ID_STRING_LEN);

        strncpy(rf->rfparamlocal.gatewayName, (char*) idstring, GATEWAY_NAME_MAX_SIZE);
        strncpy(&buf[1], (char*) idstring, GATEWAY_NAME_MAX_SIZE);
        // Update strings
        buf[0] = HPRF_CTRL_MSG_GW_CONNECTED;

		//	gateway connection established		
		RFIntRFApp.pF_PrepareAndPostDeviceDataInfoStr (RF_DEVICE_INFO_CRC_FIELD_INDEX);
	}
    else	
    {
		//	gateway connection lost
        // Inform application
        buf[0] = HPRF_CTRL_MSG_GW_DISCONNECTED;
	}
    // Inform the application about the status change
    SendCtrlMsgToApp((void*)buf, sizeof (buf));
    
    //RF_GatewayConnectionStatus(Status);
	DmConsolePrintf("Host: Gateway connection status = %x \r\n", Status);
    return SUCCESS;
}

INT32	HOSTAPPINTERFACE_GetRFID(UINT8 *rfID)
{
    struct mc13192* rf = get_driver_data();
    *rfID = rf->rfparam.RFID;
    return SUCCESS;
}

INT32	HOSTAPPINTERFACE_GetTSID(UINT32 *tsID)
{
    struct mc13192* rf = get_driver_data();
    *tsID = rf->rfparamlocal.TSID;
    return SUCCESS;
}

INT32	HOSTAPPINTERFACE_GetDeviceOptions (UINT8 *devOpts)
{
	*devOpts = 0x11;
	return SUCCESS;
}

INT32	HOSTAPPINTERFACE_TransmitPipeOverFlowOccured (UINT32 index)
{
	DmConsolePrintf ("RFTransmit Pipe overflow occured \r\n");
	return SUCCESS;
}

INT32	HOSTAPPINTERFACE_IsRFTxDebugTraceEnabled (BOOL *isEnabled)
{
    struct mc13192* rf = get_driver_data();
    *isEnabled = (rf->rfparam.RFTraceFlags & RF_RFTX_DEBUG_FLAG);
	return SUCCESS;
}

INT32	HOSTAPPINTERFACE_IsRFRxDebugTraceEnabled (BOOL *isEnabled)
{
    struct mc13192* rf = get_driver_data();
    *isEnabled = (rf->rfparam.RFTraceFlags & RF_RFRX_DEBUG_FLAG);
	return SUCCESS;
}

INT32   HOSTAPPINTERFACE_RFReceiverIndicatorFlash(void)
{
    return SUCCESS;
}

INT32   HOSTAPPINTERFACE_RFTransmitIndicatorFlash(void)
{
    return SUCCESS;
}

INT32 GetAddressMode(UINT8 *addrMode, UINT8 defAddrMode)
{
	// MNT - 3/21/2007 - Make sure this is modified!!!!!!!
	// Do not use this value
	*addrMode = defAddrMode;
	return SUCCESS;
}


INT32 GetShortAddress(UINT16 *shortAddr, UINT16 defShortAddr)
{
	// MNT - 3/21/2007 - Make sure this is modified!!!!!!!
	// Do not use this value
	*shortAddr = defShortAddr;
	return SUCCESS;
}

INT32 GetDate(short *month,short *day,short *year)
{
    return SUCCESS;
}

INT32 GetTime(long *time)
{
    *time = HwGetMsec();
    return SUCCESS;
}

INT32 IntfcHwDelayMsec(UINT32 ms)
{
    HwDelayMsec(ms);
    return SUCCESS;
}

INT32 IntfcHwDelayUsec(UINT32 us)
{
    HwDelayUsec(us);
    return SUCCESS;
}

INT32 StartupWait(enum HPRF_STARTUP_EVENT signal_event)
{
    UINT32 events = 0;
//    DmConsoleLevelPrintf(DM_ERROR_LEVEL_DEBUG, "signaling event = %02x\n", signal_event);
    OsSetEvent(g_startupEventGroup, signal_event);
    events = OsWaitEventGroupAll(g_startupEventGroup, HPRF_STARTUP_ALL_READY);
//    DmConsoleLevelPrintf(DM_ERROR_LEVEL_DEBUG, "signal_event = %02x all_events = %02lx\n",
//            signal_event, events);
    return SUCCESS;
}

INT32 SystemError(int error)
{
    DmConsoleLevelPrintf(DM_ERROR_LEVEL_FATAL, "System Error: 0x%02x\r\n", error);
	return SUCCESS;
}

INT32 ErrorHandler(char *msg)
{
    DmConsolePrintf(msg);
    return 0;
}

INT32 AcquireStartIndication(void)
{
    return SUCCESS;
}

INT32 AcquireStopIndication(void)
{
    return SUCCESS;
}

INT32 StoreAddressMode(UINT8 addrMode)
{
    return SUCCESS;
}

INT32 StoreShortAddress(UINT16 shortAddr)
{
    return SUCCESS;
}

INT32 HOSTAPPINTERFACE_DeviceLinkLost (UINT8 rfid)
{
	DmConsolePrintf ("RFDevice [%02X] Link Lost\r\n", rfid);
	return (SUCCESS);
}

INT32 HOSTAPPINTERFACE_DeviceLinkFound (UINT8 rfid)
{
	DmConsolePrintf ("RFDevice [%02X] Linked \r\n", rfid);
	return (SUCCESS);
}

INT32 HOSTAPPINTERFACE_GetDeviceDataField (UINT8 field, INT8 *pbuf, UINT16 *plen)
{
	return (SUCCESS);
}

INT32	HOSTAPPINTERFACE_CalculateBlockCRC16 (UINT16 len, UINT16 *crc, INT8 *pbuf)
{
	UINT16 calccrc = CalculateBlockCRC16( len, *crc, (void*)pbuf);
	*crc =  calccrc;
	return (SUCCESS);
}

INT32	HOSTAPPINTERFACE_IsUIDValid (BOOL *pUIDValid)
{
	UINT8	uid[UID_MAX_SIZE];
	UINT16	panid;	
	HOSTAPPINTERFACE_GetLocalDeviceUID_PANID(pUIDValid, uid, &panid, (UINT8 *)SLAVE_DEVICE_DEFAULT_UID, SLAVE_DEVICE_DEFAULT_PANID);
	return (SUCCESS);
}

INT32 HOSTAPPINTERFACE_GetLocalDeviceRFLinkLQIThr (UINT8 *pLQI, UINT8 defaultLQI)
{
	INT32	res = SUCCESS;
	*pLQI = defaultLQI;
	return (res);	
}

INT32 HOSTAPPINTERFACE_StoreLocalDeviceRFLinkLQIThr (UINT8 LQI)
{
	INT32	res = SUCCESS;
	return (res);	
}

INT32	HOSTAPPINTERFACE_GetRetryCountOnConnectionReq(UINT8 *count, UINT8 defCount)
{
    struct mc13192* rf = get_driver_data();
	*count = rf->rfparam.txPktretryonconnection;
	return SUCCESS;
}

INT32	HOSTAPPINTERFACE_StoreRetryCountOnConnectionReq(UINT8 count)
{
    struct mc13192* rf = get_driver_data();
    rf->rfparam.txPktretryonconnection = count;
    return SUCCESS;
}


INT32	HOSTAPPINTERFACE_GetPreLinkQueryPacketCnt(UINT8 *count, UINT8 defCount)
{
    struct mc13192* rf = get_driver_data();
	INT32 res = SUCCESS;
    *count = rf->rfparam.PreLinkQueryPacketCnt;
	return res;
}

INT32	HOSTAPPINTERFACE_StorePreLinkQueryPacketCnt(UINT8 count)
{
	INT32 res = SUCCESS;
    struct mc13192* rf = get_driver_data();
    rf->rfparam.PreLinkQueryPacketCnt = count;
	return res;
}

INT32	HOSTAPPINTERFACE_InitRoamingDescriptiveTable(void)
{
	INT32 res = SUCCESS;    
	return res;
}

INT32   HOSTAPPINTERFACE_SetRoamingGatewayUID_PANID(UINT8 *gwuid,UINT16 panid)
{
	INT32 res = SUCCESS;
	return res;
}

INT32 RFConsolePrintf(const char* format,...)
{
    struct mc13192* rf = get_driver_data();
    char    *s;
	int len;

    HPR_TY_DiagData Diag;
    va_list ap;

    // Just like TPS-6X
    if(!(rf->rfparam.RFTraceFlags & RF_GENERIC_DEBUG_FLAG))
    {
        return 0;
    }

    // Console printf data
    Diag.dwDataCode = HPRF_DIAG_DATA_CONSOLE_PRINT;

    s = (char *)Diag.Data.Console.buffer;
    va_start(ap,format);
    len = vsnprintf(s, sizeof(Diag.Data.Console.buffer),format,ap);
    va_end(ap);
	
    // Print message (use RETAIL messages too)
    DmConsolePrintf("%s", s);
    // Send to application
    Diag.Data.Console.dwStrLen = len;
    SendDiagDataToApp(&Diag, sizeof (HPR_TY_DiagData));

    return len;
}


INT32 RFErrorPrintf(const char* format,...)
{
    char    *s;
    int len = 0;
    va_list ap;

#ifdef HPRF_ERR_MSG_LOG
    // Static pointer to fill up the error log buffer..
    static CHAR* pPtr = RfErrorLog.RFErrorMsgBuff;

    // If some one resets the error log, we start from beginning..
    if (RfErrorLog.NoErrorMsgs == 0)
    {
        pPtr = RfErrorLog.RFErrorMsgBuff;
    }

    // Leave room for last message....
    if (RfErrorLog.TotalBytes < (HPRF_ERR_MSG_LOG_BUF_SIZE - 256))
    {
        s = (char *)pPtr;
        va_start(ap,format);
        len = _vsnprintf(s, 256, format, ap);
        va_end(ap);

        // Count the NULL also.
        RfErrorLog.TotalBytes += (len+1);
        RfErrorLog.NoErrorMsgs++;
        // Advance the pointer...
        pPtr = pPtr + len + 1;
    }
#else
    char sArray[256];
    s = (char *) &sArray[0];
    va_start(ap,format);
    len = vsnprintf(s, sizeof(sArray),format,ap);
    va_end(ap);
    DmConsolePrintf("%s", sArray);
#endif
    return len;
}
